/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui.components.sidebar;

import java.util.Optional;
import java.util.function.Predicate;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.css.PseudoClass;
import javafx.scene.control.Tooltip;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.gui.components.sidebar.Selectable;
import org.pdfsam.gui.components.sidebar.SidebarButton;
import org.pdfsam.model.ui.ContentItem;
import org.pdfsam.model.ui.SetActiveContentItemRequest;
import org.sejda.commons.util.RequireUtils;

public class SelectableSidebarButton
extends SidebarButton
implements Selectable {
    private static final PseudoClass SELECTED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"selected");
    private final String id;
    private final BooleanProperty selected = new SimpleBooleanProperty(false){

        protected void invalidated() {
            SelectableSidebarButton.this.pseudoClassStateChanged(SELECTED_PSEUDOCLASS_STATE, this.get());
            SelectableSidebarButton.this.setDisable(this.get());
        }
    };

    SelectableSidebarButton(String id, String text) {
        super(text);
        RequireUtils.requireNotBlank((String)id, (String)"ID cannot be blank");
        this.id = id;
    }

    public String id() {
        return this.id;
    }

    public final BooleanProperty selectedProperty() {
        return this.selected;
    }

    @Override
    public final void setSelected(boolean value) {
        this.selectedProperty().set(value);
    }

    @Override
    public final boolean isSelected() {
        return this.selected.get();
    }

    @Override
    public final void selectIf(String id) {
        this.selectedProperty().set(this.id.equals(id));
    }

    public static SelectableSidebarButton of(ContentItem item) {
        RequireUtils.requireNotNullArg((Object)item, (String)"ContentItem cannot be null");
        SelectableSidebarButton button = new SelectableSidebarButton(item.id(), item.name());
        button.setOnAction(e -> StaticStudio.eventStudio().broadcast((Object)new SetActiveContentItemRequest(item.id())));
        button.setGraphic(item.graphic());
        Optional.ofNullable(item.description()).filter(Predicate.not(String::isBlank)).map(Tooltip::new).ifPresent(arg_0 -> ((SelectableSidebarButton)button).setTooltip(arg_0));
        return button;
    }
}

