/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui.components.sidebar;

import javafx.beans.property.BooleanProperty;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import org.pdfsam.gui.components.sidebar.SidebarButton;
import org.pdfsam.gui.components.sidebar.SidebarNotificationType;
import org.sejda.commons.util.RequireUtils;

class SidebarButtonWithNotification<T extends SidebarButton>
extends StackPane {
    private final T wrapped;
    private final Node graphic;
    private final SidebarNotificationType notificationType;

    public SidebarButtonWithNotification(T wrapped, Node notificationGraphic, SidebarNotificationType notificationType) {
        RequireUtils.requireNotNullArg(wrapped, (String)"Wrapped button cannot be null");
        RequireUtils.requireNotNullArg((Object)wrapped.getGraphic(), (String)"Wrapped button graphic cannot be null");
        RequireUtils.requireNotNullArg((Object)((Object)notificationType), (String)"Notification type cannot be null");
        this.wrapped = wrapped;
        this.graphic = notificationGraphic;
        this.notificationType = notificationType;
        notificationGraphic.setVisible(false);
        this.setStyle("-fx-background-color: rgba(0, 0, 0, 0);");
        Pane notification = new Pane();
        notification.getStyleClass().addAll((Object[])new String[]{"sidebar-button-notification-container", notificationType.getCssClass()});
        notification.getChildren().add((Object)notificationGraphic);
        notification.setMouseTransparent(true);
        wrapped.addEventHandler(ActionEvent.ACTION, e -> this.graphic.setVisible(false));
        this.getChildren().addAll((Object[])new Node[]{wrapped, notification});
        this.wrapped.getGraphic().boundsInParentProperty().addListener((observable, oldValue, newValue) -> this.graphic.relocate(newValue.getMaxX() - 10.0, newValue.getMaxY() - 10.0));
        this.graphic.visibleProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.wrapped.getStyleClass().add((Object)notificationType.getCssClass());
            } else {
                this.wrapped.getStyleClass().remove((Object)notificationType.getCssClass());
            }
        });
    }

    public void showNotification() {
        this.graphic.setVisible(true);
    }

    public void hideNotification() {
        this.graphic.setVisible(false);
    }

    public BooleanProperty displayTextProperty() {
        return ((SidebarButton)((Object)this.wrapped)).displayTextProperty();
    }

    T getWrapped() {
        return this.wrapped;
    }

    public static Node notificationOf(Node node) {
        node.getStyleClass().add((Object)"notification");
        return node;
    }
}

