/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui.components.sidebar;

import java.util.Optional;
import java.util.function.Predicate;
import javafx.scene.control.Tooltip;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.gui.components.sidebar.SelectableSidebarButton;
import org.pdfsam.model.tool.Tool;
import org.pdfsam.model.tool.ToolCategory;
import org.pdfsam.model.ui.SetActiveContentItemRequest;
import org.sejda.commons.util.RequireUtils;

public class ToolSelectableSidebarButton
extends SelectableSidebarButton {
    private final int order;
    private final ToolCategory category;

    ToolSelectableSidebarButton(String id, String text, ToolCategory category, int order) {
        super(id, text);
        this.order = order;
        this.category = category;
        this.getStyleClass().add((Object)"tool-selectable-sidebar-button");
    }

    public int order() {
        return this.order;
    }

    public ToolCategory category() {
        return this.category;
    }

    public static ToolSelectableSidebarButton of(Tool tool, int order) {
        RequireUtils.requireNotNullArg((Object)tool, (String)"Tool cannot be null");
        ToolSelectableSidebarButton button = new ToolSelectableSidebarButton(tool.id(), tool.descriptor().name(), tool.descriptor().category(), order);
        button.setOnAction(e -> StaticStudio.eventStudio().broadcast((Object)new SetActiveContentItemRequest(tool.id())));
        button.setGraphic(tool.graphic());
        Optional.ofNullable(tool.descriptor().description()).filter(Predicate.not(String::isBlank)).map(Tooltip::new).ifPresent(arg_0 -> ((ToolSelectableSidebarButton)button).setTooltip(arg_0));
        return button;
    }
}

