/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui.components.sidebar;

import jakarta.inject.Inject;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.gui.components.content.about.AboutContentItem;
import org.pdfsam.gui.components.content.home.HomeContentItem;
import org.pdfsam.gui.components.content.preference.PreferenceContentItem;
import org.pdfsam.gui.components.sidebar.ExitButton;
import org.pdfsam.gui.components.sidebar.ExpandButton;
import org.pdfsam.gui.components.sidebar.LogButton;
import org.pdfsam.gui.components.sidebar.NewsButton;
import org.pdfsam.gui.components.sidebar.Selectable;
import org.pdfsam.gui.components.sidebar.SelectableSidebarButton;
import org.pdfsam.gui.components.sidebar.SidebarButton;
import org.pdfsam.gui.components.sidebar.SidebarButtonWithNotification;
import org.pdfsam.gui.components.sidebar.ToolsButtons;
import org.pdfsam.gui.components.sidebar.WorkspaceButton;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.ui.ContentItem;
import org.pdfsam.model.ui.SetActiveContentItemRequest;
import org.pdfsam.model.ui.ShowLogMessagesRequest;

public class VerticalSidebar
extends BorderPane {
    private final ToolsButtons tools;
    private final VBox buttons = new VBox();

    @Inject
    public VerticalSidebar(HomeContentItem homeItem, LogButton logButton, NewsButton newsButton, PreferenceContentItem preferenceItem, AboutContentItem aboutItem, WorkspaceButton workspaceButton, ToolsButtons tools) {
        this.getStyleClass().add((Object)"vertical-sidebar");
        this.tools = tools;
        ExpandButton expandButton = new ExpandButton();
        this.setTop((Node)expandButton);
        this.buttons.getStyleClass().add((Object)"sidebar-buttons");
        this.addButton(homeItem, expandButton);
        Label toolsLabel = new Label(I18nContext.i18n().tr("Tools").toUpperCase());
        toolsLabel.getStyleClass().add((Object)"sidebar-title");
        toolsLabel.contentDisplayProperty().bind(expandButton.selectedProperty().map(b -> b != false ? ContentDisplay.LEFT : ContentDisplay.GRAPHIC_ONLY));
        this.buttons.getChildren().addAll((Object[])new Node[]{new Separator(Orientation.HORIZONTAL), toolsLabel});
        tools.getChildren().forEach(b -> {
            if (b instanceof SidebarButton) {
                SidebarButton button = (SidebarButton)((Object)b);
                button.displayTextProperty().bind((ObservableValue)expandButton.selectedProperty());
            }
        });
        this.buttons.getChildren().add((Object)tools);
        Region spacer = new Region();
        spacer.getStyleClass().add((Object)"spacer");
        VBox.setVgrow((Node)spacer, (Priority)Priority.ALWAYS);
        this.buttons.getChildren().add((Object)spacer);
        this.addButton(workspaceButton, expandButton);
        this.addButton(logButton, expandButton);
        this.addButton(newsButton, expandButton);
        this.addButton(aboutItem, expandButton);
        this.addButton(preferenceItem, expandButton);
        this.buttons.getChildren().add((Object)new Separator(Orientation.HORIZONTAL));
        this.addButton(new ExitButton(), expandButton);
        ScrollPane scroll = new ScrollPane((Node)this.buttons);
        scroll.getStyleClass().add((Object)"sidebar-scroll");
        this.setCenter((Node)scroll);
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    private void addButton(ContentItem item, ExpandButton expandButton) {
        if (!item.disabled()) {
            SelectableSidebarButton button = SelectableSidebarButton.of(item);
            button.displayTextProperty().bind((ObservableValue)expandButton.selectedProperty());
            this.buttons.getChildren().add((Object)button);
        }
    }

    private void addButton(SidebarButton button, ExpandButton expandButton) {
        button.displayTextProperty().bind((ObservableValue)expandButton.selectedProperty());
        this.buttons.getChildren().add((Object)button);
    }

    private void addButton(SidebarButtonWithNotification button, ExpandButton expandButton) {
        button.displayTextProperty().bind((ObservableValue)expandButton.selectedProperty());
        this.buttons.getChildren().add((Object)button);
    }

    @EventListener
    public void onSetCurrentContentItem(SetActiveContentItemRequest r) {
        Selectable button;
        for (Node child : this.buttons.getChildren()) {
            if (!(child instanceof Selectable)) continue;
            button = (Selectable)child;
            button.selectIf(r.id());
        }
        for (Node child : this.tools.getChildren()) {
            if (!(child instanceof Selectable)) continue;
            button = (Selectable)child;
            button.selectIf(r.id());
        }
    }

    @EventListener
    public void onShowErrorMessagesRequest(ShowLogMessagesRequest request) {
        this.onSetCurrentContentItem(new SetActiveContentItemRequest("LOGS"));
    }
}

