/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.persistence;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.pdfsam.persistence.EntityRepository;
import org.pdfsam.persistence.PersistenceException;
import org.pdfsam.persistence.PreferencesRepository;
import org.sejda.commons.util.RequireUtils;

public class DefaultEntityRepository<T>
implements EntityRepository<T> {
    private final ObjectMapper mapper;
    private final Class<T> clazz;
    private final PreferencesRepository repo;

    public DefaultEntityRepository(String path, ObjectMapper mapper, Class<T> clazz) {
        RequireUtils.requireNotNullArg((Object)mapper, (String)"Mapper cannot be null");
        RequireUtils.requireNotNullArg(clazz, (String)"Type class cannot be null");
        this.repo = new PreferencesRepository(path);
        this.mapper = mapper;
        this.clazz = clazz;
    }

    @Override
    public Optional<T> get(String key) throws PersistenceException {
        try {
            Optional<String> value = Optional.ofNullable(this.repo.getString(key, (String)null));
            if (value.isPresent()) {
                return Optional.ofNullable(this.mapper.readValue(value.get(), this.clazz));
            }
        }
        catch (IOException e) {
            throw new PersistenceException(String.format("Unable to get entity: [key '%s']", key), e);
        }
        return Optional.empty();
    }

    @Override
    public T get(String key, T defaultValue) {
        return this.get(key).orElse(defaultValue);
    }

    @Override
    public int getInt(String key, int defaultValue) {
        return this.repo.getInt(key, defaultValue);
    }

    @Override
    public long getLong(String key, long defaultValue) {
        return this.repo.getLong(key, defaultValue);
    }

    @Override
    public String getString(String key, String defaultValue) {
        return this.repo.getString(key, defaultValue);
    }

    @Override
    public String getString(String key, Supplier<String> supplier) {
        return this.repo.getString(key, supplier);
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        return this.repo.getBoolean(key, defaultValue);
    }

    @Override
    public void save(String key, T entity) throws PersistenceException {
        RequireUtils.requireNotBlank((String)key, (String)"Key cannot be blank");
        try {
            if (Objects.nonNull(entity)) {
                this.repo.saveString(key, this.mapper.writeValueAsString(entity));
            } else {
                this.repo.delete(key);
            }
        }
        catch (IOException e) {
            throw new PersistenceException(String.format("Unable to store entity: [key '%s', entity '%s']", key, entity), e);
        }
    }

    @Override
    public void saveInt(String key, int value) throws PersistenceException {
        this.repo.saveInt(key, value);
    }

    @Override
    public void saveLong(String key, long value) throws PersistenceException {
        this.repo.saveLong(key, value);
    }

    @Override
    public void saveString(String key, String value) throws PersistenceException {
        this.repo.saveString(key, value);
    }

    @Override
    public void saveBoolean(String key, boolean value) {
        this.repo.saveBoolean(key, value);
    }

    @Override
    public String[] keys() {
        return this.repo.keys();
    }

    @Override
    public void delete(String key) throws PersistenceException {
        this.repo.delete(key);
    }

    @Override
    public void clean() throws PersistenceException {
        this.repo.clean();
    }
}

