/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.tools.splitbybookmarks;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.scene.control.ComboBox;
import org.pdfsam.core.support.params.TaskParametersBuildStep;
import org.pdfsam.core.support.validation.Validators;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.ui.ResettableView;
import org.pdfsam.model.ui.workspace.RestorableView;
import org.pdfsam.tools.splitbybookmarks.SplitByOutlineLevelParametersBuilder;
import org.pdfsam.ui.components.support.FXValidationSupport;
import org.pdfsam.ui.components.support.Style;

class BookmarksLevelComboBox
extends ComboBox<String>
implements TaskParametersBuildStep<SplitByOutlineLevelParametersBuilder>,
RestorableView,
ResettableView {
    private final FXValidationSupport<String> validationSupport = new FXValidationSupport();

    BookmarksLevelComboBox() {
        this.validationSupport.setValidator(Validators.alwaysFalse());
        this.setEditable(true);
        this.getSelectionModel().selectFirst();
        this.valueProperty().addListener((o, oldVal, newVal) -> this.validate());
        this.validationSupport.validationStateProperty().addListener(o -> {
            if (this.validationSupport.validationStateProperty().get() == FXValidationSupport.ValidationState.INVALID) {
                this.getEditor().getStyleClass().addAll((Object[])Style.INVALID.css());
            } else {
                this.getEditor().getStyleClass().removeAll((Object[])Style.INVALID.css());
            }
        });
    }

    public void setValidBookmarkLevels(SortedSet<Integer> levels) {
        this.getItems().clear();
        if (Objects.nonNull(levels)) {
            this.validationSupport.setValidator(Validators.containedInteger(levels));
            levels.stream().map(Object::toString).forEach(arg_0 -> this.getItems().add(arg_0));
        } else {
            this.validationSupport.setValidator(Validators.alwaysFalse());
        }
    }

    public final FXValidationSupport.ValidationState getValidationState() {
        return (FXValidationSupport.ValidationState)this.validationSupport.validationStateProperty().get();
    }

    public final ReadOnlyObjectProperty<FXValidationSupport.ValidationState> validProperty() {
        return this.validationSupport.validationStateProperty();
    }

    public void validate() {
        this.validationSupport.validate((Object)((String)this.getValue()));
    }

    public void resetView() {
        this.getItems().clear();
        this.getEditor().clear();
    }

    public void apply(SplitByOutlineLevelParametersBuilder builder, Consumer<String> onError) {
        this.validate();
        if (this.validationSupport.validationStateProperty().get() == FXValidationSupport.ValidationState.VALID) {
            builder.level(Integer.parseInt((String)this.getValue()));
        } else {
            onError.accept(I18nContext.i18n().tr("Invalid bookmarks level"));
        }
    }

    public void saveStateTo(Map<String, String> data) {
        data.put("levelCombo.levels", String.join((CharSequence)",", (Iterable<? extends CharSequence>)this.getItems()));
        data.put("levelCombo.selected", Optional.ofNullable((String)this.getValue()).orElse(""));
    }

    public void restoreStateFrom(Map<String, String> data) {
        this.getSelectionModel().selectFirst();
        Optional.ofNullable(data.get("levelCombo.max")).map(Integer::valueOf).ifPresent(max -> IntStream.rangeClosed(1, max).mapToObj(Integer::toString).forEach(arg_0 -> this.getItems().add(arg_0)));
        Arrays.stream(Optional.ofNullable(data.get("levelCombo.levels")).map(l -> l.split(",")).orElse(new String[0])).forEach(arg_0 -> this.getItems().add(arg_0));
        this.setValue(Optional.ofNullable(data.get("levelCombo.selected")).orElse(""));
    }
}

