/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.tools.rotate;

import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.layout.HBox;
import org.pdfsam.core.support.params.TaskParametersBuildStep;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.ui.ComboItem;
import org.pdfsam.model.ui.ResettableView;
import org.pdfsam.model.ui.workspace.RestorableView;
import org.pdfsam.tools.rotate.RotateParametersBuilder;
import org.pdfsam.ui.components.support.Style;
import org.sejda.model.pdf.page.PredefinedSetOfPages;
import org.sejda.model.rotation.Rotation;

class RotateOptionsPane
extends HBox
implements TaskParametersBuildStep<RotateParametersBuilder>,
RestorableView,
ResettableView {
    private final ComboBox<ComboItem<PredefinedSetOfPages>> rotationType = new ComboBox();
    private final ComboBox<ComboItem<Rotation>> rotation = new ComboBox();

    RotateOptionsPane() {
        super(5.0);
        this.rotationType.getItems().add((Object)new ComboItem((Object)PredefinedSetOfPages.ALL_PAGES, I18nContext.i18n().tr("All pages")));
        this.rotationType.getItems().add((Object)new ComboItem((Object)PredefinedSetOfPages.EVEN_PAGES, I18nContext.i18n().tr("Even pages")));
        this.rotationType.getItems().add((Object)new ComboItem((Object)PredefinedSetOfPages.ODD_PAGES, I18nContext.i18n().tr("Odd pages")));
        this.rotationType.setId("rotationType");
        this.rotation.getItems().add((Object)new ComboItem((Object)Rotation.DEGREES_90, I18nContext.i18n().tr("90 degrees clockwise")));
        this.rotation.getItems().add((Object)new ComboItem((Object)Rotation.DEGREES_180, I18nContext.i18n().tr("180 degrees clockwise")));
        this.rotation.getItems().add((Object)new ComboItem((Object)Rotation.DEGREES_270, I18nContext.i18n().tr("90 degrees counterclockwise")));
        this.rotation.setId("rotation");
        this.getStyleClass().addAll((Object[])Style.HCONTAINER.css());
        this.getStyleClass().addAll((Object[])Style.CONTAINER.css());
        this.resetView();
        this.getChildren().addAll((Object[])new Node[]{new Label(I18nContext.i18n().tr("Rotate ")), this.rotationType, this.rotation});
    }

    public void resetView() {
        this.rotationType.getSelectionModel().selectFirst();
        this.rotation.getSelectionModel().selectFirst();
    }

    public void apply(RotateParametersBuilder builder, Consumer<String> onError) {
        builder.rotation((Rotation)((ComboItem)this.rotation.getSelectionModel().getSelectedItem()).key());
        builder.rotationType((PredefinedSetOfPages)((ComboItem)this.rotationType.getSelectionModel().getSelectedItem()).key());
    }

    public void saveStateTo(Map<String, String> data) {
        data.put("rotation", Optional.ofNullable((ComboItem)this.rotation.getSelectionModel().getSelectedItem()).map(i -> ((Rotation)i.key()).toString()).orElse(""));
        data.put("rotationType", Optional.ofNullable((ComboItem)this.rotationType.getSelectionModel().getSelectedItem()).map(i -> ((PredefinedSetOfPages)i.key()).toString()).orElse(""));
    }

    public void restoreStateFrom(Map<String, String> data) {
        Optional.ofNullable(data.get("rotation")).map(Rotation::valueOf).flatMap(key -> this.rotation.getItems().stream().filter(i -> ((Rotation)i.key()).equals(key)).findFirst()).ifPresent(arg_0 -> ((SingleSelectionModel)this.rotation.getSelectionModel()).select(arg_0));
        Optional.ofNullable(data.get("rotationType")).map(PredefinedSetOfPages::valueOf).flatMap(key -> this.rotationType.getItems().stream().filter(i -> ((PredefinedSetOfPages)i.key()).equals(key)).findFirst()).ifPresent(arg_0 -> ((SingleSelectionModel)this.rotationType.getSelectionModel()).select(arg_0));
    }
}

