/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.tools.rotate;

import jakarta.inject.Named;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.unicons.UniconsLine;
import org.pdfsam.core.context.ApplicationContext;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.injector.Auto;
import org.pdfsam.injector.Provides;
import org.pdfsam.model.tool.Tool;
import org.pdfsam.model.tool.ToolCategory;
import org.pdfsam.model.tool.ToolDescriptor;
import org.pdfsam.model.tool.ToolDescriptorBuilder;
import org.pdfsam.model.tool.ToolInputOutputType;
import org.pdfsam.model.tool.ToolPriority;
import org.pdfsam.persistence.PreferencesRepository;
import org.pdfsam.tools.rotate.RotateToolPanel;
import org.pdfsam.ui.components.io.BrowsableField;
import org.pdfsam.ui.components.io.BrowsableOutputDirectoryField;
import org.pdfsam.ui.components.io.PdfDestinationPane;
import org.pdfsam.ui.components.prefix.PrefixPane;
import org.pdfsam.ui.components.tool.Footer;
import org.pdfsam.ui.components.tool.OpenButton;
import org.pdfsam.ui.components.tool.RunButton;

@Auto
public class RotateTool
implements Tool {
    static final String TOOL_ID = "rotate";
    private final ToolDescriptor descriptor = ToolDescriptorBuilder.builder().category(ToolCategory.OTHER).inputTypes(new ToolInputOutputType[]{ToolInputOutputType.MULTIPLE_PDF, ToolInputOutputType.SINGLE_PDF}).name(I18nContext.i18n().tr("Rotate")).description(I18nContext.i18n().tr("Rotate the pages of multiple PDF documents.")).priority(ToolPriority.DEFAULT.getPriority()).supportURL("https://pdfsam.org/rotate-pdf/").build();

    public ToolDescriptor descriptor() {
        return this.descriptor;
    }

    public Pane panel() {
        return (Pane)ApplicationContext.app().instance(RotateToolPanel.class);
    }

    public String id() {
        return TOOL_ID;
    }

    public Node graphic() {
        FontIcon icon = new FontIcon((Ikon)UniconsLine.ROTATE_360);
        icon.getStyleClass().addAll((Object[])new String[]{this.descriptor().category().styleClass(), "tool-icon"});
        return icon;
    }

    public static class ModuleConfig {
        @Provides
        @Named(value="rotatefield")
        public BrowsableOutputDirectoryField destinationDirectoryField() {
            return new BrowsableOutputDirectoryField();
        }

        @Provides
        @Named(value="rotatepane")
        public PdfDestinationPane destinationPane(@Named(value="rotatefield") BrowsableOutputDirectoryField outputField) {
            return new PdfDestinationPane((BrowsableField)outputField, RotateTool.TOOL_ID, new PdfDestinationPane.DestinationPanelFields[0]);
        }

        @Provides
        @Named(value="rotatefooter")
        public Footer footer(RunButton runButton, @Named(value="rotateopenButton") OpenButton openButton) {
            return new Footer(runButton, openButton, RotateTool.TOOL_ID);
        }

        @Provides
        @Named(value="rotateopenButton")
        public OpenButton openButton() {
            return new OpenButton(RotateTool.TOOL_ID, ToolInputOutputType.MULTIPLE_PDF);
        }

        @Provides
        @Named(value="rotateprefix")
        public PrefixPane prefixPane() {
            return new PrefixPane(RotateTool.TOOL_ID, new PreferencesRepository("/org/pdfsam/user/conf/rotate"));
        }
    }
}

