using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Net.NetworkInformation;

namespace NetSpeed
{
    public partial class MainWindow : Form
    {
        int iInterface = 0;             // found interfaces
        int iInterfaceUp = 0;           // interfaces up
        int iFirstUp = -1;
        long lngBytesSend = 0;
        long lngBytesReceived = 0;

        NetworkInterface oInterface;    // selected interface object

        public MainWindow()
        {
            InitializeComponent();

            timerMain.Stop();

            foreach (NetworkInterface anInterface in NetworkInterface.GetAllNetworkInterfaces())
            {
                MenuInterfacesAdd(anInterface);
            }

            if (0 < iInterface)
            {
                menuInterfaces.Text += " (" + iInterfaceUp.ToString();
                menuInterfaces.Text += "/" + iInterface.ToString() + ")";
                if (-1 == iFirstUp)
                {
                    iFirstUp = 0;
                }
                SelectInterface(iFirstUp);
            }
            else
            {
                IsDown();
            }

        }

        private void MenuInterfacesAdd(NetworkInterface anInterface)
        {
            if(anInterface.NetworkInterfaceType.ToString() != "Tunnel")
            {
                ToolStripMenuItem oItem = new ToolStripMenuItem(anInterface.OperationalStatus.ToString() + ": " + anInterface.Name);
                oItem.ForeColor = Color.DarkGray;
                oItem.Tag       = iInterface;
                oItem.Click     += new System.EventHandler(this.SelectInterface);
                oItem.Image = NetSpeed.Properties.Resources.button_red;
                if (anInterface.OperationalStatus.ToString() == "Up")
                {
                    oItem.ForeColor = Color.Black;
                    oItem.Image = NetSpeed.Properties.Resources.button_green;
                    iInterfaceUp++;
                    if (-1 == iFirstUp)
                    {
                        iFirstUp = iInterface;
                    }
                }
                menuInterfaces.DropDownItems.Add(oItem);
                iInterface++;
            }
        }

        private void SelectInterface()
        {
            lblName.Text = oInterface.Name;
            this.Text = "NetSpeed " + oInterface.OperationalStatus.ToString() + " " + oInterface.Name;

            if (oInterface.OperationalStatus.ToString() == "Up")
            {
                IsUp();
            }
            else
            {
                IsDown();
            }
        }

        private void SelectInterface(int iId)
        {
            if (null != NetworkInterface.GetAllNetworkInterfaces()[iId])
            {
                oInterface = NetworkInterface.GetAllNetworkInterfaces()[iId];
                SelectInterface();
            }
        }

        private void SelectInterface(object sender, EventArgs e)
        {
            ToolStripMenuItem oItem = sender as ToolStripMenuItem;
            SelectInterface((int)oItem.Tag);
        }

        private void IsUp()
        {
            if (null != (oInterface.GetIPProperties().UnicastAddresses[1].Address))
            {
                lblName.Text += "\r" + (oInterface.GetIPProperties().UnicastAddresses[1].Address).ToString();
                if (null != (oInterface.GetIPProperties().UnicastAddresses[1].IPv4Mask))
                    lblName.Text += "\r" + (oInterface.GetIPProperties().UnicastAddresses[1].IPv4Mask).ToString();
            }
            else
            {
                lblName.Text += "\r" + (oInterface.GetIPProperties().UnicastAddresses[0].Address).ToString();
            }
            
            timerMain.Start();
            notifyMain.BalloonTipTitle = this.Text;
            lblName.ForeColor = Color.Black;
            cbNotify.Enabled = true;
            this.ClientSize = new System.Drawing.Size(267, 210);
        }

        private void IsDown()
        {
            timerMain.Stop();
            lblName.ForeColor = Color.Gray;
            lblName.Text += "\rDown";
            cbNotify.Checked = false;
            cbNotify.Enabled = false;
            this.ClientSize = new System.Drawing.Size(267, 80);
        }

        private void tmrRefresh_Tick(object sender, EventArgs e)
        {
            IPv4InterfaceStatistics interfaceStatistic = oInterface.GetIPv4Statistics();

            int bytesSentSpeed = (int)(interfaceStatistic.BytesSent - lngBytesSend) / 1024;
            int bytesReceivedSpeed = (int)(interfaceStatistic.BytesReceived - lngBytesReceived) / 1024;

            lblSpeed.Text = (oInterface.Speed / 1000000).ToString() + " Mbps";
            lblSr.Text = interfaceStatistic.UnicastPacketsSent.ToString() + "/" + interfaceStatistic.UnicastPacketsReceived.ToString();
            lblUl.Text = bytesSentSpeed.ToString() + " KB/s";
            lblDl.Text = bytesReceivedSpeed.ToString() + " KB/s";
            lngBytesSend = interfaceStatistic.BytesSent;
            lngBytesReceived = interfaceStatistic.BytesReceived;

            if (
                (cbNotify.Checked == true) &&
                ((bytesReceivedSpeed >= 1) || (bytesSentSpeed >= 1))
              )
            {
                notifyMain.Text = "UL: " + lblUl.Text + "\nDL: " + lblDl.Text;
                notifyMain.BalloonTipText = notifyMain.Text;
                notifyMain.ShowBalloonTip(1500);
            }
        }

        private void ReloadApp(object sender, EventArgs e)
        {
            Application.Restart();
        }

        private void CloseApp(object sender, EventArgs e)
        {
            Environment.Exit(0);
         }
    
    }
}
