using System;

using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Runtime.InteropServices;
using System.Text;
using System.Windows.Forms;
using System.Net.NetworkInformation;

namespace Devoldere.NetSpeedTray
{
    public partial class MainWindow : Form
    {
        //private bool dragging = false;
        //private Point dragCursorPoint;
        //private Point dragFormPoint;

        //public const int WM_NCLBUTTONDOWN = 0xA1;
        //public const int HT_CAPTION = 0x2;
        
        int iInterface = 0;             // found interfaces
        int iInterfaceUp = 0;           // interfaces up
        int iFirstUp = -1;
        long lngBytesSend = 0;
        long lngBytesReceived = 0;

        private StringBuilder _bytesUnit;

        NetworkInterface oInterface;    // selected interface object

        public MainWindow()
        {
            InitializeComponent();

            oTimer.Stop();

            foreach (NetworkInterface anInterface in NetworkInterface.GetAllNetworkInterfaces())
            {
                MenuInterfacesAdd(anInterface);
            }

            if (0 < iInterface)
            {
                menuInterfaces.Text += " (" + iInterfaceUp.ToString();
                menuInterfaces.Text += "/" + (iInterface - iInterfaceUp).ToString() + ")";
                if (-1 == iFirstUp)
                {
                    iFirstUp = 0;
                }
                SelectInterface(iFirstUp);
            }
            else
            {
                IsDown();
            }
        }

        private void MenuInterfacesAdd(NetworkInterface anInterface)
        {
            if(anInterface.NetworkInterfaceType.ToString() != "Tunnel")
            {
                ToolStripMenuItem oItem = new ToolStripMenuItem(anInterface.OperationalStatus.ToString() + ": " + anInterface.Name);
                oItem.ForeColor = Color.DarkGray;
                oItem.Tag       = iInterface;
                oItem.Click     += new System.EventHandler(this.SelectInterface);
                oItem.Image = Devoldere.NetSpeedTray.Properties.Resources.scroll_down_png;
                if (anInterface.OperationalStatus.ToString() == "Up")
                {
                    oItem.ForeColor = Color.Black;
                    oItem.Image = Devoldere.NetSpeedTray.Properties.Resources.scroll_up_png;
                    iInterfaceUp++;
                    if (-1 == iFirstUp)
                    {
                        iFirstUp = iInterface;
                    }
                }
                menuInterfaces.DropDownItems.Add(oItem);
                iInterface++;
            }
        }

        private void SelectInterface()
        {
            lblName.Text = oInterface.Name;
            this.Text = oInterface.Name + " " + oInterface.OperationalStatus.ToString();

            if (oInterface.OperationalStatus.ToString() == "Up")
            {
                IsUp();
            }
            else
            {
                IsDown();
            }
        }

        private void SelectInterface(int iId)
        {
            if (null != NetworkInterface.GetAllNetworkInterfaces()[iId])
            {
                oInterface = NetworkInterface.GetAllNetworkInterfaces()[iId];
                SelectInterface();
            }
        }

        private void SelectInterface(object sender, EventArgs e)
        {
            ToolStripMenuItem oItem = sender as ToolStripMenuItem;
            SelectInterface((int)oItem.Tag);
        }

        private void IsUp()
        {
            if (null != (oInterface.GetIPProperties().UnicastAddresses[1].Address))
            {
                lblName.Text += "\r" + (oInterface.GetIPProperties().UnicastAddresses[1].Address).ToString();
                if (null != (oInterface.GetIPProperties().UnicastAddresses[1].IPv4Mask))
                    lblName.Text += "\r" + (oInterface.GetIPProperties().UnicastAddresses[1].IPv4Mask).ToString();
            }
            else
            {
                lblName.Text += "\r" + (oInterface.GetIPProperties().UnicastAddresses[0].Address).ToString();
                this.Icon = Devoldere.NetSpeedTray.Properties.Resources.scroll;
            }
            lblName.Text += "\r" + (oInterface.Speed / 1000000).ToString() + " Mbps"; ;
            
            oTimer.Start();
            oNotify.BalloonTipTitle = this.Text;
            lblName.ForeColor = Color.Black;
            cbNotify.Enabled = true;
            this.ClientSize = new System.Drawing.Size(202, 152);
            this.Icon = Devoldere.NetSpeedTray.Properties.Resources.scroll_up;
        }

        private void IsDown()
        {
            oTimer.Stop();
            lblName.ForeColor = Color.Gray;
            lblName.Text += "\rDown";
            cbNotify.Checked = false;
            cbNotify.Enabled = false;
            this.ClientSize = new System.Drawing.Size(202, 80);
            this.Icon = Devoldere.NetSpeedTray.Properties.Resources.scroll_down;
        }

        private void tmrRefresh_Tick(object sender, EventArgs e)
        {
            IPv4InterfaceStatistics interfaceStatistic = oInterface.GetIPv4Statistics();

            int bytesSentSpeed = (int)(interfaceStatistic.BytesSent - lngBytesSend);
            int bytesReceivedSpeed = (int)(interfaceStatistic.BytesReceived - lngBytesReceived);

            //lblSpeed.Text = (oInterface.Speed / 1000000).ToString() + " Mbps";
            lblSrUp.Text = interfaceStatistic.UnicastPacketsSent.ToString();
            lblSrDown.Text = interfaceStatistic.UnicastPacketsReceived.ToString();
            lblBytesUp.Text = BytesFormat(interfaceStatistic.BytesSent, "B", 1024);
            lblBytesDown.Text = BytesFormat(interfaceStatistic.BytesReceived, "B", 1024);
            lblUl.Text = BytesFormat(bytesSentSpeed, "B/s", 1024);
            lblDl.Text = BytesFormat(bytesReceivedSpeed, "B/s", 1024);
            lngBytesSend = interfaceStatistic.BytesSent;
            lngBytesReceived = interfaceStatistic.BytesReceived;

            if (
                (cbNotify.Checked == true) &&
                ((bytesReceivedSpeed >= 1) || (bytesSentSpeed >= 1))
              )
            {
                oNotify.Text = "UL: " + lblUl.Text + "\nDL: " + lblDl.Text;
                oNotify.BalloonTipText = oNotify.Text;
                oNotify.ShowBalloonTip(2500);
            }
        }

        private string BytesFormat(double iValue, string sFormat, int iDivider)
        {
            if (iValue == 0)
                return "0";

            _bytesUnit = new StringBuilder(sFormat, 5);

            if (iValue > 1073741824) // 1gb
            {
                iValue = iValue / iDivider / iDivider / iDivider;
                _bytesUnit.Insert(0, "G");
            }
            else if (iValue > 1048576) // 1mb
            {
                iValue = iValue / iDivider / iDivider;
                _bytesUnit.Insert(0, "M");
            }
            else if (iValue > 1024) // 1kb
            {
                iValue = iValue / iDivider;
                _bytesUnit.Insert(0, "K");
            }

            _bytesUnit.Insert(0, " ");

            return iValue.ToString("#.##") + _bytesUnit.ToString();
        }

        private void ReloadApp(object sender, EventArgs e)
        {
            Application.Restart();
        }

        private void CloseApp(object sender, EventArgs e)
        {
            Environment.Exit(0);
        }

        private void AboutApp(object sender, EventArgs e)
        {
            DialogResult mResult =  MessageBox.Show
            (
                "NetSpeedTray  1.0.0.1  (2014/12)\rMickal  Devoldre\rhttp://devoldere.net\r\rDo you wish to visit devoldere.net ?",
                "DEVOLDERE",
                MessageBoxButtons.YesNo,
                MessageBoxIcon.None
             );

            if(mResult == DialogResult.Yes)
            {
                System.Diagnostics.Process.Start("http://devoldere.net");
            }
        }

        private void notifyIcon_MouseClick(object sender, MouseEventArgs e)
        {
            cbNotify.Checked = (this.Visible == true) ? cbNotify.Checked : false; 
            this.Visible = (this.Visible == true) ? false : true;
            //this.Location = new Point
            //(
            //    (Screen.PrimaryScreen.Bounds.Width - 290), 
            //    (Screen.PrimaryScreen.Bounds.Height - 290)
            //);
        }

        //[DllImportAttribute("user32.dll")]
        //public static extern int SendMessage(IntPtr hWnd, int Msg, int wParam, int lParam);
        //[DllImportAttribute("user32.dll")]
        //public static extern bool ReleaseCapture();

        //private void Win_MouseDown(object sender, System.Windows.Forms.MouseEventArgs e)
        //{
        //    if (e.Button == MouseButtons.Left)
        //    {
        //        ReleaseCapture();
        //        SendMessage(Handle, WM_NCLBUTTONDOWN, HT_CAPTION, 0);
        //    }
        //}

        //private void Win_MouseDown(object sender, MouseEventArgs e)
        //{
        //    dragging = true;
        //    dragCursorPoint = Cursor.Position;
        //    dragFormPoint = this.Location;
        //}

        //private void Win_MouseMove(object sender, MouseEventArgs e)
        //{
        //    if (dragging)
        //    {
        //        Point dif = Point.Subtract(Cursor.Position, new Size(dragCursorPoint));
        //        this.Location = Point.Add(dragFormPoint, new Size(dif));
        //    }
        //}

        //private void Win_MouseUp(object sender, MouseEventArgs e)
        //{
        //    dragging = false;
        //}
    
    }
}
