﻿using System;
using System.Drawing;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Net.NetworkInformation;
using System.Windows.Threading;

namespace NetworkSpeed
{
    /// <summary>
    /// Logique d'interaction pour MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        private DispatcherTimer timer;
        private int elapsed;
        
        public MainWindow()
        {
            InitializeComponent();
            NetworkerContainer.Refresh();
            elapsed = 0;
            timer = new DispatcherTimer();
            timer.Interval = TimeSpan.FromSeconds(1);
            timer.Tick += Timer_Tick;
        }

        private void GridMain_Loaded(object sender, RoutedEventArgs e)
        {
            foreach (Networker oIf in NetworkerContainer.listInterface)
            {
                MenuItem oItem = new MenuItem();
                oItem.Header = oIf.ToString();
                oItem.Tag = oIf.id;
                oItem.Click += MenuInterfaces_Selection;
                MenuInterfaces.Items.Add(oItem);
            }
            timer.Start();
        }

        private void Timer_Tick(object sender, EventArgs e)
        {
            if (elapsed == 0)
                RefreshInterfaceInfo(false);
            else if (elapsed % 2 == 0)
                 RefreshInterfaceInfo(true);
            RefreshInterfaceTraffice();
            elapsed++;
        }

        private void RefreshInterfaceInfo(bool bCheck)
        {
            if(bCheck == true)
                NetworkerContainer.oInterface.Refresh();

            tbxHeader.Text = NetworkerContainer.oInterface.ToStringNameIp();
            tbxMac.Text = NetworkerContainer.oInterface.ToStringDescription();
        }

        private void RefreshInterfaceTraffice()
        {
            NetworkerContainer.oInterface.Traffice();
            tbxSpeed.Text           = NetworkerContainer.oInterface.speed;
            tbxSentReceived.Text    = NetworkerContainer.oInterface.packetSentReceived;
            tbxUpload.Text          = (NetworkerContainer.oInterface.iBytesSentDiff / 1024).ToString() + " KB/s";
            tbxDownload.Text        = (NetworkerContainer.oInterface.iBytesReceivedDiff / 1024).ToString() + " KB/s";
        }

        private void MenuInterfaces_Selection(object sender, RoutedEventArgs e)
        {
            System.Windows.Controls.MenuItem Mi = sender as System.Windows.Controls.MenuItem;
            NetworkerContainer.GetInterface((int)Mi.Tag);
        }

        private void MenuExit_Click(object sender, RoutedEventArgs e)
        {
            Environment.Exit(0);
        }



    }
}
