﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Controls;
using System.Net.NetworkInformation;
using System.Windows.Media;

namespace NetworkSpeed
{
    class Networker
    {
        internal static int iTotal = 0;

        internal NetworkInterface oInterface;

        internal int    id;
        internal string status;
        internal string speed;
        internal string name;
        internal string description;
        internal string type;
        internal string mac;
        internal string ipv4;
        //internal string ipv4mask;
        internal string ipv6;

        internal long   lngBytesSent;
        internal long   lngBytesReceived;
        internal int    iBytesSentDiff;
        internal int    iBytesReceivedDiff;
        internal string packetSentReceived;

        private IPv4InterfaceStatistics oStatistic;

        public Networker(NetworkInterface anInterface)
        {
            if (null == anInterface)
            {
                throw new Exception("Invalid interface");
            }
            else
            {
                id               = iTotal;                
                lngBytesSent     = 0;
                lngBytesReceived = 0;
                oInterface       = anInterface;
                Refresh();
                iTotal++;
            }
        }

        public void Refresh()
        {
            status = oInterface.OperationalStatus.ToString();
            name   = oInterface.Name;

            if (status == "Up")
            {
                speed       = (oInterface.Speed / 1000000).ToString() + " Mbps";
                description = oInterface.Description;
                type        = oInterface.NetworkInterfaceType.ToString();
                mac         = oInterface.GetPhysicalAddress().ToString();
                Ip();
            }
        }

        public void Ip()
        {
            if (null != (oInterface.GetIPProperties().UnicastAddresses[1].Address).ToString())
            {
                ipv4 = (oInterface.GetIPProperties().UnicastAddresses[1].Address).ToString();
                //ipv4mask = (oInterface.GetIPProperties().UnicastAddresses[1].IPv4Mask).ToString();
                ipv6 = (oInterface.GetIPProperties().UnicastAddresses[0].Address).ToString();
            }
            else
            {
                ipv4 = (oInterface.GetIPProperties().UnicastAddresses[0].Address).ToString();
                //ipv4mask = (oInterface.GetIPProperties().UnicastAddresses[0].IPv4Mask).ToString();
                ipv6 = "";
            }
        }

        public void Traffice()
        {
            oStatistic = oInterface.GetIPv4Statistics();
            iBytesSentDiff     = (int)(oStatistic.BytesSent - lngBytesSent);
            iBytesReceivedDiff = (int)(oStatistic.BytesReceived - lngBytesReceived);
            packetSentReceived = oStatistic.UnicastPacketsSent.ToString() + "/" + oStatistic.UnicastPacketsReceived.ToString();
            lngBytesSent       = oStatistic.BytesSent;
            lngBytesReceived   = oStatistic.BytesReceived;
        }

        public string ToStringNameIp()
        {
            return name + "\r"
                   + ipv4 + "\r"
                   + ipv6;
        }

        public string ToStringDescription()
        {
            return "MAC: " + mac + "\r" + description;
        }

        public override string ToString()
        {
            return ipv4 + " " + name;
        }
    }
}
