/*
 * Decompiled with CFR 0.152.
 */
package com.phonegap;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Parcelable;
import android.provider.MediaStore;
import com.phonegap.DirectoryManager;
import com.phonegap.ExifHelper;
import com.phonegap.FileUtils;
import com.phonegap.api.LOG;
import com.phonegap.api.Plugin;
import com.phonegap.api.PluginResult;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CameraLauncher
extends Plugin {
    private static final int DATA_URL = 0;
    private static final int FILE_URI = 1;
    private static final int PHOTOLIBRARY = 0;
    private static final int CAMERA = 1;
    private static final int SAVEDPHOTOALBUM = 2;
    private static final int PICTURE = 0;
    private static final int VIDEO = 1;
    private static final int ALLMEDIA = 2;
    private static final int JPEG = 0;
    private static final int PNG = 1;
    private static final String GET_PICTURE = "Get Picture";
    private static final String GET_VIDEO = "Get Video";
    private static final String GET_All = "Get All";
    private static final String LOG_TAG = "CameraLauncher";
    private int mQuality;
    private int targetWidth;
    private int targetHeight;
    private Uri imageUri;
    private int encodingType;
    private int mediaType;
    public String callbackId;
    private int numPics;

    public PluginResult execute(String action, JSONArray args, String callbackId) {
        PluginResult.Status status = PluginResult.Status.OK;
        String result = "";
        this.callbackId = callbackId;
        try {
            if (action.equals("takePicture")) {
                int srcType = 1;
                int destType = 1;
                this.targetHeight = 0;
                this.targetWidth = 0;
                this.encodingType = 0;
                this.mediaType = 0;
                this.mQuality = 80;
                JSONObject options = args.optJSONObject(0);
                if (options != null) {
                    srcType = options.getInt("sourceType");
                    destType = options.getInt("destinationType");
                    this.targetHeight = options.getInt("targetHeight");
                    this.targetWidth = options.getInt("targetWidth");
                    this.encodingType = options.getInt("encodingType");
                    this.mediaType = options.getInt("mediaType");
                    this.mQuality = options.getInt("quality");
                }
                if (srcType == 1) {
                    this.takePicture(destType, this.encodingType);
                } else if (srcType == 0 || srcType == 2) {
                    this.getImage(srcType, destType);
                }
                PluginResult r = new PluginResult(PluginResult.Status.NO_RESULT);
                r.setKeepCallback(true);
                return r;
            }
            return new PluginResult(status, result);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return new PluginResult(PluginResult.Status.JSON_EXCEPTION);
        }
    }

    public void takePicture(int returnType, int encodingType) {
        this.numPics = this.queryImgDB().getCount();
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        File photo = this.createCaptureFile(encodingType);
        intent.putExtra("output", (Parcelable)Uri.fromFile((File)photo));
        this.imageUri = Uri.fromFile((File)photo);
        this.ctx.startActivityForResult(this, intent, 32 + returnType + 1);
    }

    private File createCaptureFile(int encodingType) {
        File photo = null;
        if (encodingType == 0) {
            photo = new File(DirectoryManager.getTempDirectoryPath((Context)this.ctx), "Pic.jpg");
        } else if (encodingType == 1) {
            photo = new File(DirectoryManager.getTempDirectoryPath((Context)this.ctx), "Pic.png");
        } else {
            throw new IllegalArgumentException("Invalid Encoding Type: " + encodingType);
        }
        return photo;
    }

    public void getImage(int srcType, int returnType) {
        Intent intent = new Intent();
        String title = GET_PICTURE;
        if (this.mediaType == 0) {
            intent.setType("image/*");
        } else if (this.mediaType == 1) {
            intent.setType("video/*");
            title = GET_VIDEO;
        } else if (this.mediaType == 2) {
            intent.setType("*/*");
            title = GET_All;
        }
        intent.setAction("android.intent.action.GET_CONTENT");
        intent.addCategory("android.intent.category.OPENABLE");
        this.ctx.startActivityForResult(this, Intent.createChooser((Intent)intent, (CharSequence)new String(title)), (srcType + 1) * 16 + returnType + 1);
    }

    public Bitmap scaleBitmap(Bitmap bitmap) {
        int newWidth = this.targetWidth;
        int newHeight = this.targetHeight;
        int origWidth = bitmap.getWidth();
        int origHeight = bitmap.getHeight();
        if (newWidth <= 0 && newHeight <= 0) {
            return bitmap;
        }
        if (newWidth > 0 && newHeight <= 0) {
            newHeight = newWidth * origHeight / origWidth;
        } else if (newWidth <= 0 && newHeight > 0) {
            newWidth = newHeight * origWidth / origHeight;
        } else {
            double origRatio = (double)origWidth / (double)origHeight;
            double newRatio = (double)newWidth / (double)newHeight;
            if (origRatio > newRatio) {
                newHeight = newWidth * origHeight / origWidth;
            } else if (origRatio < newRatio) {
                newWidth = newHeight * origWidth / origHeight;
            }
        }
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)newWidth, (int)newHeight, (boolean)true);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent intent) {
        int srcType = requestCode / 16 - 1;
        int destType = requestCode % 16 - 1;
        if (srcType == 1) {
            if (resultCode == -1) {
                try {
                    Uri uri;
                    Bitmap bitmap;
                    ExifHelper exif = new ExifHelper();
                    if (this.encodingType == 0) {
                        exif.createInFile(DirectoryManager.getTempDirectoryPath((Context)this.ctx) + "/Pic.jpg");
                        exif.readExifData();
                    }
                    try {
                        bitmap = MediaStore.Images.Media.getBitmap((ContentResolver)this.ctx.getContentResolver(), (Uri)this.imageUri);
                    }
                    catch (FileNotFoundException e) {
                        uri = intent.getData();
                        ContentResolver resolver = this.ctx.getContentResolver();
                        bitmap = BitmapFactory.decodeStream((InputStream)resolver.openInputStream(uri));
                    }
                    bitmap = this.scaleBitmap(bitmap);
                    if (destType == 0) {
                        this.processPicture(bitmap);
                        this.checkForDuplicateImage(0);
                    } else if (destType == 1) {
                        ContentValues values = new ContentValues();
                        values.put("mime_type", "image/jpeg");
                        uri = null;
                        try {
                            uri = this.ctx.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
                        }
                        catch (UnsupportedOperationException e) {
                            LOG.d(LOG_TAG, "Can't write to external media storage.");
                            try {
                                uri = this.ctx.getContentResolver().insert(MediaStore.Images.Media.INTERNAL_CONTENT_URI, values);
                            }
                            catch (UnsupportedOperationException ex) {
                                LOG.d(LOG_TAG, "Can't write to internal media storage.");
                                this.failPicture("Error capturing image - no media storage found.");
                                return;
                            }
                        }
                        OutputStream os = this.ctx.getContentResolver().openOutputStream(uri);
                        bitmap.compress(Bitmap.CompressFormat.JPEG, this.mQuality, os);
                        os.close();
                        if (this.encodingType == 0) {
                            exif.createOutFile(FileUtils.getRealPathFromURI(uri, this.ctx));
                            exif.writeExifData();
                        }
                        this.success(new PluginResult(PluginResult.Status.OK, uri.toString()), this.callbackId);
                    }
                    bitmap.recycle();
                    bitmap = null;
                    System.gc();
                    this.checkForDuplicateImage(1);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.failPicture("Error capturing image.");
                }
            } else if (resultCode == 0) {
                this.failPicture("Camera cancelled.");
            } else {
                this.failPicture("Did not complete!");
            }
        } else if (srcType == 0 || srcType == 2) {
            if (resultCode == -1) {
                Uri uri = intent.getData();
                ContentResolver resolver = this.ctx.getContentResolver();
                if (this.mediaType != 0) {
                    this.success(new PluginResult(PluginResult.Status.OK, uri.toString()), this.callbackId);
                } else if (destType == 0) {
                    try {
                        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)resolver.openInputStream(uri));
                        bitmap = this.scaleBitmap(bitmap);
                        this.processPicture(bitmap);
                        bitmap.recycle();
                        bitmap = null;
                        System.gc();
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                        this.failPicture("Error retrieving image.");
                    }
                } else if (destType == 1) {
                    if (this.targetHeight > 0 && this.targetWidth > 0) {
                        try {
                            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)resolver.openInputStream(uri));
                            bitmap = this.scaleBitmap(bitmap);
                            String fileName = DirectoryManager.getTempDirectoryPath((Context)this.ctx) + "/resize.jpg";
                            FileOutputStream os = new FileOutputStream(fileName);
                            bitmap.compress(Bitmap.CompressFormat.JPEG, this.mQuality, (OutputStream)os);
                            ((OutputStream)os).close();
                            bitmap.recycle();
                            bitmap = null;
                            this.success(new PluginResult(PluginResult.Status.OK, "file://" + fileName + "?" + System.currentTimeMillis()), this.callbackId);
                            System.gc();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            this.failPicture("Error retrieving image.");
                        }
                    } else {
                        this.success(new PluginResult(PluginResult.Status.OK, uri.toString()), this.callbackId);
                    }
                }
            } else if (resultCode == 0) {
                this.failPicture("Selection cancelled.");
            } else {
                this.failPicture("Selection did not complete!");
            }
        }
    }

    private Cursor queryImgDB() {
        return this.ctx.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, new String[]{"_id"}, null, null, null);
    }

    private void checkForDuplicateImage(int type) {
        int diff = 1;
        Cursor cursor = this.queryImgDB();
        int currentNumOfImages = cursor.getCount();
        if (type == 1) {
            diff = 2;
        }
        if (currentNumOfImages - this.numPics == diff) {
            cursor.moveToLast();
            int id = Integer.valueOf(cursor.getString(cursor.getColumnIndex("_id"))) - 1;
            Uri uri = Uri.parse((String)(MediaStore.Images.Media.EXTERNAL_CONTENT_URI + "/" + id));
            this.ctx.getContentResolver().delete(uri, null, null);
        }
    }

    public void processPicture(Bitmap bitmap) {
        ByteArrayOutputStream jpeg_data = new ByteArrayOutputStream();
        try {
            if (bitmap.compress(Bitmap.CompressFormat.JPEG, this.mQuality, (OutputStream)jpeg_data)) {
                byte[] code = jpeg_data.toByteArray();
                byte[] output = Base64.encodeBase64((byte[])code);
                String js_out = new String(output);
                this.success(new PluginResult(PluginResult.Status.OK, js_out), this.callbackId);
                js_out = null;
                output = null;
                code = null;
            }
        }
        catch (Exception e) {
            this.failPicture("Error compressing image.");
        }
        jpeg_data = null;
    }

    public void failPicture(String err) {
        this.error(new PluginResult(PluginResult.Status.ERROR, err), this.callbackId);
    }
}

