/*
 * Decompiled with CFR 0.152.
 */
package com.phonegap;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.KeyEvent;
import android.view.View;
import android.webkit.ConsoleMessage;
import android.webkit.GeolocationPermissions;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebStorage;
import android.webkit.WebView;
import android.widget.EditText;
import com.phonegap.DroidGap;
import com.phonegap.api.LOG;
import org.json.JSONArray;
import org.json.JSONException;

public class CordovaChromeClient
extends WebChromeClient {
    private String TAG = "PhoneGapLog";
    private long MAX_QUOTA = 0x6400000L;
    private DroidGap ctx;

    public CordovaChromeClient(Context ctx) {
        this.ctx = (DroidGap)ctx;
    }

    public boolean onJsAlert(WebView view, String url, String message, final JsResult result) {
        AlertDialog.Builder dlg = new AlertDialog.Builder((Context)this.ctx);
        dlg.setMessage((CharSequence)message);
        dlg.setTitle((CharSequence)"Alert");
        dlg.setCancelable(true);
        dlg.setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                result.confirm();
            }
        });
        dlg.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                result.confirm();
            }
        });
        dlg.setOnKeyListener(new DialogInterface.OnKeyListener(){

            public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                if (keyCode == 4) {
                    result.confirm();
                    return false;
                }
                return true;
            }
        });
        dlg.create();
        dlg.show();
        return true;
    }

    public boolean onJsConfirm(WebView view, String url, String message, final JsResult result) {
        AlertDialog.Builder dlg = new AlertDialog.Builder((Context)this.ctx);
        dlg.setMessage((CharSequence)message);
        dlg.setTitle((CharSequence)"Confirm");
        dlg.setCancelable(true);
        dlg.setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                result.confirm();
            }
        });
        dlg.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                result.cancel();
            }
        });
        dlg.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                result.cancel();
            }
        });
        dlg.setOnKeyListener(new DialogInterface.OnKeyListener(){

            public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                if (keyCode == 4) {
                    result.cancel();
                    return false;
                }
                return true;
            }
        });
        dlg.create();
        dlg.show();
        return true;
    }

    public boolean onJsPrompt(WebView view, String url, String message, String defaultValue, JsPromptResult result) {
        boolean reqOk = false;
        if (url.startsWith("file://") || url.indexOf(this.ctx.baseUrl) == 0 || this.ctx.isUrlWhiteListed(url)) {
            reqOk = true;
        }
        if (reqOk && defaultValue != null && defaultValue.length() > 3 && defaultValue.substring(0, 4).equals("gap:")) {
            try {
                JSONArray array = new JSONArray(defaultValue.substring(4));
                String service = array.getString(0);
                String action = array.getString(1);
                String callbackId = array.getString(2);
                boolean async = array.getBoolean(3);
                String r = this.ctx.pluginManager.exec(service, action, callbackId, message, async);
                result.confirm(r);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else if (reqOk && defaultValue != null && defaultValue.equals("gap_poll:")) {
            String r = this.ctx.callbackServer.getJavascript();
            result.confirm(r);
        } else if (reqOk && defaultValue != null && defaultValue.equals("gap_callbackServer:")) {
            String r = "";
            if (message.equals("usePolling")) {
                r = "" + this.ctx.callbackServer.usePolling();
            } else if (message.equals("restartServer")) {
                this.ctx.callbackServer.restartServer();
            } else if (message.equals("getPort")) {
                r = Integer.toString(this.ctx.callbackServer.getPort());
            } else if (message.equals("getToken")) {
                r = this.ctx.callbackServer.getToken();
            }
            result.confirm(r);
        } else if (reqOk && defaultValue != null && defaultValue.equals("gap_init:")) {
            this.ctx.appView.setVisibility(0);
            this.ctx.spinnerStop();
            result.confirm("OK");
        } else {
            final JsPromptResult res = result;
            AlertDialog.Builder dlg = new AlertDialog.Builder((Context)this.ctx);
            dlg.setMessage((CharSequence)message);
            final EditText input = new EditText((Context)this.ctx);
            if (defaultValue != null) {
                input.setText((CharSequence)defaultValue);
            }
            dlg.setView((View)input);
            dlg.setCancelable(false);
            dlg.setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    String usertext = input.getText().toString();
                    res.confirm(usertext);
                }
            });
            dlg.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    res.cancel();
                }
            });
            dlg.create();
            dlg.show();
        }
        return true;
    }

    public void onExceededDatabaseQuota(String url, String databaseIdentifier, long currentQuota, long estimatedSize, long totalUsedQuota, WebStorage.QuotaUpdater quotaUpdater) {
        LOG.d(this.TAG, "DroidGap:  onExceededDatabaseQuota estimatedSize: %d  currentQuota: %d  totalUsedQuota: %d", estimatedSize, currentQuota, totalUsedQuota);
        if (estimatedSize < this.MAX_QUOTA) {
            long newQuota = estimatedSize;
            LOG.d(this.TAG, "calling quotaUpdater.updateQuota newQuota: %d", newQuota);
            quotaUpdater.updateQuota(newQuota);
        } else {
            quotaUpdater.updateQuota(currentQuota);
        }
    }

    public void onConsoleMessage(String message, int lineNumber, String sourceID) {
        LOG.d(this.TAG, "%s: Line %d : %s", sourceID, lineNumber, message);
        super.onConsoleMessage(message, lineNumber, sourceID);
    }

    public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
        if (consoleMessage.message() != null) {
            LOG.d(this.TAG, consoleMessage.message());
        }
        return super.onConsoleMessage(consoleMessage);
    }

    public void onGeolocationPermissionsShowPrompt(String origin, GeolocationPermissions.Callback callback) {
        super.onGeolocationPermissionsShowPrompt(origin, callback);
        callback.invoke(origin, true, false);
    }
}

