/*
  Lécu Régis
  12/07/2016
 Trame à compléter sur les attaques par injection SQL
*/
package outils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;


/**
 * Outils d'authentification
 * @author regis
 */
public class Authentification
{
    /**
     * Authentifie l'utilisateur par son nom et son mot de passe
     * @param con : chaine de connexion jdbc
     * @param nom : nom de l'utiliseur
     * @param motpasse : mot de passe
     * @return  : vrai si l'utilisateur existe
     */   
    public static boolean userExistV2(Connection con, String nom, String motpasse) {
      
        boolean existe = false;
        // le texte de la requête paramétrée ne contient que du SQL sûr
        // les emplacements des paramètres sont marqués par des points d’interrogation
        String req = "select count(*) from utilisateur where name=? and mdp=?";
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try
        {
            // on crée la requête paramétrée à partir d’une connexion existante
            pstmt = con.prepareStatement(req);

            // on donne les valeurs des paramètres à la requête
            pstmt.setString(1, nom);
            pstmt.setString(2, motpasse);
            
            // appel de la requête paramétrée 
            rs = pstmt.executeQuery();
            if (rs.next()) {
                // on code EXACTEMENT la fonctionnalité demandée
                // (en supposant l’unicité du nom) 	
                if (rs.getInt(1) == 1) {
                    existe = true;
                }
            }
        } catch (SQLException e) {
            System.out.println("Exception : " + e.getMessage());
        }
        finally
        {           
          try 
          {
              if (pstmt != null)
                 pstmt.close();
              if (rs != null)
               rs.close();
            } catch (SQLException ex) {
                  System.out.println("Exception : " + ex.getMessage());
            }
            
        }
        return existe;
    }


}
