/*
Régis Lécu
25/08/2016
Classe de connexion de base de données pour démonstration d'injection SQL
*/
package outils;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;


/**
 * 
 * @author regis
 */
public class ConnexionBdd {

    private static ConnexionBdd _instance = null;

/**
 * 
 * @return 
 */
    synchronized 
    public static ConnexionBdd getInstance() {
        if (_instance == null) {
            _instance = new ConnexionBdd();
        }
        return _instance;
    }

    /**
     * Ouvre une connexion jdbc pour l'utilisateur 
     * @param user : nom de l'utilisateur
     * @param pwd ; password de l'utilisateur
     * @return : connexion jdbc ou null
     */
    public Connection ouvrir(String user, String pwd) 
    {
        Connection co = null;
        try 
        {
            // pour la démonstration, utilisation de la base derby
            // à laquelle on a ajouté la table Utilisateur
            // TODO : initialisez ici votre connexion vers SQL Server ou Oracle 
            Class.forName("org.apache.derby.jdbc.ClientDriver");
            String url = "jdbc:derby://localhost:1527/sample";          

            co = DriverManager.getConnection(url, user, pwd);
            
        } catch (ClassNotFoundException | SQLException e) {
           System.err.println (e.getMessage());
        }

        return co;
    }

}
