/**
 * Copyright (c) 2014 Oracle and/or its affiliates. All rights reserved.
 Commentaires : Lécu Régis, 2016 
 * Pour simplifier, je suis passé du projet MAVEN initial à un projet standard
 * et je n'ai pas fait de projet "common" entre le client et le serveur
 */
package javaeetutorial.cartsecure.ejb;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javaeetutorial.cartsecure.util.BookException;
import javaeetutorial.cartsecure.util.IdVerifier;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.ejb.Remove;
import javax.ejb.Stateful;

// 1) il faut un ejb session à état (Stateful) pour conserver la liste d'articles etc.
@Stateful
@DeclareRoles("TutorialUser")                      // 2) ejb utilisé par le rôle de sécurité : TutorialUser
public class CartBean implements Cart, Serializable {

    String customerId;          // id du client 
    String customerName;
    List<String> contents;

    // 3) l'initialisation du panier par le client n'a pas de restriction
    @Override
    public void initialize(String person) throws BookException {
        if (person == null) {
            throw new BookException("Null person not allowed.");
        } else {
            customerName = person;
        }

        customerId = "0";
        contents = new ArrayList<>();
    }

    @Override
    public void initialize(String person, String id) throws BookException {
        if (person == null) {
            throw new BookException("Null person not allowed.");
        } else {
            customerName = person;
        }

        IdVerifier idChecker = new IdVerifier();
        if (idChecker.validate(id)) {
            customerId = id;
        } else {
            throw new BookException("Invalid id: " + id);
        }

        contents = new ArrayList<>();
    }

    @Override
    @RolesAllowed ("TutorialUser")
    public void addBook(String title) {
        contents.add(title);
    }

    // 4) toutes les autres méthodes métiers sont restreintes au rôle de sécurité TutorialUser
    @Override
    @RolesAllowed ("TutorialUser")
    public void removeBook(String title) throws BookException {
        boolean result = contents.remove(title);

        if (result == false) {
            throw new BookException("\"" + title + "\" not in cart.");
        }
    }

    @Override
    @RolesAllowed ("TutorialUser")
    public List<String> getContents() {
        return contents;
    }

    @Remove()
    @Override
    @RolesAllowed ("TutorialUser")
    public void remove() {
        contents = null;
    }
}
