/*
   Serveur SSL : 
   Lcu Rgis 11/10/2016
   
   Programme de dmonstration de liaison SSL :
   ce serveur reoit des chaines du client et les affiche
*/

import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;

public class ServerSSL
 {
	private static final int NPORT = 9000; // numro de port IP du socket SSL
    public static void  main(String[] args)
	{
        try 
		{
			// 1 rcupration de la "factory" par dfaut de serveur de sockets SSL
            SSLServerSocketFactory sslFact  = (SSLServerSocketFactory) SSLServerSocketFactory.getDefault();
			
			// 2 cration d'un serveur de socket SSL sur le port NPORT
            SSLServerSocket sslServerSock  = (SSLServerSocket) sslFact.createServerSocket(NPORT);
			
			// 3 attente sur le port NPORT par le socket sslsock
            SSLSocket sslsock = (SSLSocket) sslServerSock.accept();

			// 4 lecture de messages texte sur le socket SSL
            InputStream instream = sslsock.getInputStream();
            InputStreamReader inreader = new InputStreamReader(instream);
            BufferedReader bufreader = new BufferedReader(inreader);

			System.out.println ("==== Demo Serveur SSL : reception message texte =====");
			String s = bufreader.readLine();   // lecture d'une ligne sur le socket SSL
			int n = 0;
            while (s != null)
			{  
				n++;
				System.out.println(n + " =>" + s) ;				
				s = bufreader.readLine();   // lecture d'une ligne sur le socket SSL
			}         
        } 
		catch (Exception ex) 
		{
            System.out.println (ex.getMessage() );
        }
    }
}
