/* Programme C de dmonstration de l'integer overflow
Lcu Rgis, 08/06/2016

Ce programme fait la dmonstration de l'integer overflow
et d'une exploitation possible (indexation d'un tableau)
*/
#include <stdio.h>
#include <stdlib.h>

int main()
{	
	printf("\n\n********** L'integer overflow en langage C *************************");

	printf("\n(1) --- Provoquons un integer overflow ---\n");
	printf("%s", "Nombre ? (entre 0 et 65535)");
	// essayer des nombres < 65535 et suprieurs pour provoquer un Integer Overflow
	// Cet overflow peut passer inaperu et conduire  une exploitation par un attaquant
	unsigned short int nombre = 0;
	
	scanf("%d", &nombre);
	printf("Votre nombre est en realite : %d\n", nombre);

	// tableau de dmonstration : chaque case contient une copie de l'indice	
	#define MAX		70000					// nombre total de cases du tableau (INCOHERENT avec le type de l'indice !)
	#define NBPRIV	30000					// nombre de cases rserves  un utilisateur privilgi en dbut de tableau

	char tab[MAX];
	int i;
	for (i = 0; i < NBPRIV ; i++)
		tab[i] = 'P';					// case "privilgie" marque par un P
	for (i = NBPRIV; i < MAX ; i++)
		tab[i] = 'U';					// case "utilisateur lamda" marque par un U


	printf("(2) --- Une premiere exploitation de l'integer overflow ---\n");
	printf("Votre indice entre 0 et %d ?", MAX - NBPRIV);
	scanf("%d", &nombre);
	if  (nombre > MAX-NBPRIV )
		printf ("Indice errone:%d\n", nombre);
	else
	{
		// rentrez un nombre  partir de 35536 pour provoquer l'overflow
		unsigned short int i = NBPRIV + nombre;
		printf("L'utilisateur de base consulte la donnee numero : %d\n", i);
		printf("La donnee demandee est: %c\n", tab[i]);
	}	
}