/* Le partage maximal (hash consing) et ses surprises. Démo sur l'Integer Boxing
Lécu Régis, 14/06/2016 (repris d'un exemple ANSII)

Java optimise la déclaration de ses constantes en mémoire dans un cache, mais il
ne faut pas baser son raisonnement sur ces optimisations, qui cachent des pièges
Le mécanisme d'AutoBoxing et Unboxing permet à Java d'échanger des types simples
(int) et l'objet "wrapper" correspondant (Integer).
Dans l'exemple (très mal pensé) :
- le programmeur compare directement les Integer
(donc leur référence) 
- les objets Wrapper sont rangés dans un cache mémoire, et pour une même constante numérique,
le compilateur tente de réutiliser le même wrapper, mais le cache a une taille limitée, ce qui
explique que
- pour a1 et a2 le compilateur utilise le même wrapper et l'égalité (entre les références d'objet)
est donc vrai
- pour b1 et b2 le compilateur utilise deux wrappers et l'égalité est fausse.
Que se passerait il si par introspection, on accédait à ce cache pour le corrompre ?
*/
package demopartage;
public class IntegerBoxing
{
    public static void main(String[] args) {
        Integer a1 = 42;
        Integer a2 = 42;
        if (a1 == a2) 
        {
            System.out.println("a1 == a2");
        }
        Integer b1 = 1000;
        Integer b2 = 1000;
        if (b1 == b2) {
            System.out.println("b1 == b2");
        }
        
    }

}

/*
Le partage maximal (hash consing) est une approche intéressante, mise en oeuvre
par exemple dans les bibliothèques standards de Java

Listing 14 : snippets/java/IntegerBoxing.java
Ici a1==a2 mais pas b1==b2, ce qui met en évidence un mécanisme de cache de
taille limitée ; mais que se passerait-il si par introspection on accédait à ce cache
pour le corrompre ?
PCh,
*/
