package demonumericexception;
/*
Lécu Régis, 21/06/2016

    Version sécurisée de DemoIntegerOverflow
    Ce programme sécurise le calcul et évite l'integer overflow par deux méthodes :
- une fonction safeAdd qui teste les préconditions du calcul et lève l'exception
ArithmeticException sir le calcul n'est pas possible
- la fonction Math.addExact fait la même chose, mais elle est intégrée à Java depuis la version 8

*/

public class DemoNumericExceptionSecure {
   static public final int safeAdd(int left, int right) {
        if (right > 0 ? left > Integer.MAX_VALUE - right : left < Integer.MIN_VALUE - right) {
            throw new ArithmeticException("Integer overflow");
        }
        return  (left + right);
    }
    
    public static void main(String[] args)
    {
        System.out.println("* Gestion sécurisée de l'integer overflow en Java ***");

        // 1) méthode par le test des préconditions
        int i = 1;  
        try 
        {
            while (i < Integer.MAX_VALUE - 1000)
            {                  
               // i = i + 100000;               
               i = safeAdd(i,  100000);
            }
        } 
        catch (Exception e) 
        {        
            System.out.println("Avant l'overflow, i vaut : " + i);   
            System.out.println(e);
        }        
        // 2) méthode Java 8 en utilisant Math.addExact
        i = 1;
        try 
        {
            while (i < Integer.MAX_VALUE - 1000)
            {                  
               // i = i + 100000;               
               i = Math.addExact(i,  100000);
            }
        } 
        catch (Exception e) 
        {
        
            System.out.println("Avant l'overflow i vaut :" + i);   
            System.out.println(e);
        }
        
      
    }
}
        
   

