package deserialisation;
import java.io.*;
import java.util.*;
// Lécu Régis, 21/06/2016
// On hérite de la classe standard ObjectInputStream pour lui ajouter
// des propriétés de sécurité : seules les classes présentes dans une
// LISTE BLANCHE fournie pourront être désérialisées
// Pour les autres classes, on lève l'exception InvalidClassException
class WhitelistedObjectInputStream extends ObjectInputStream 
{
  public Set whitelist;         // Liste blanche des classes autorisées 
 
  // on passe la liste blanche au constructeur
  public WhitelistedObjectInputStream(InputStream inputStream, Set wl) throws IOException {
    super(inputStream);
    whitelist = wl;
  }
  
  // on vérifie dans le resolveClass que la classe à désérialiser, passé en paramètre,
  // est bien dans la liste blanche des classes autorisées
  @Override
  protected Class<?> resolveClass(ObjectStreamClass cls) throws IOException, ClassNotFoundException 
  {
    if (!whitelist.contains(cls.getName())) 
    {
      throw new InvalidClassException("class serialisee inattendue", cls.getName());
    }
    return super.resolveClass(cls);
  }
}
         
public class DeserialSec        
{
    public static void main(String[] args)
            throws FileNotFoundException, IOException,
            ClassNotFoundException
    {
        FileInputStream fis = new FileInputStream("friend");

        // création de la liste blanche 
        Set listeBlanche = new HashSet<String> ();
        listeBlanche.add ("ClassBisounours");
        // mettre la ligne suivante en commentaire pour interdire la classe et lever l'exception
        listeBlanche.add ("deserialisation.Friend");

        ObjectInputStream ois = new WhitelistedObjectInputStream(fis, listeBlanche);
        Friend f = (Friend) ois.readObject();
        
        System.out.println("Je récupère bien : " + f.getSomething() );
    }
}
