/*
 Exemple de Jean Michel Doudoux sur le wrap/unwrap de clés
Le "wrapping" de clés permet de communiquer de façon sécurisée 
des clés privées de différents algorithmes
 */
package crypto;

import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class TestKeyWrap {

    public static void main(String[] args) {

        try 
        {
            // génération de la clé à envelopper
            KeyGenerator generator = KeyGenerator.getInstance("AES");
            generator.init(128);
            SecretKey cleAEnvelopper = generator.generateKey();
            System.out.println("cle          : " + Tools.toStringHex(cleAEnvelopper.getEncoded()));

            // wrap de la clé
            Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
            KeyGenerator KeyGen = KeyGenerator.getInstance("AES");
            KeyGen.init(128);
            Key clePourChiffrer = KeyGen.generateKey();
            cipher.init(Cipher.WRAP_MODE, clePourChiffrer);
            byte[] cleEnveloppee = cipher.wrap(cleAEnvelopper);
            System.out.println("cle wrapped  : " + Tools.toStringHex(cleEnveloppee));

            // unwrap de la clé
            cipher.init(Cipher.UNWRAP_MODE, clePourChiffrer);
            Key key = cipher.unwrap(cleEnveloppee, "AES", Cipher.SECRET_KEY);
            System.out.println("cle unwrapped: " + Tools.toStringHex(key.getEncoded()));

        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
